/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.Fog;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.LinearFogRetained;
import javax.media.j3d.Node;
import javax.vecmath.Color3f;

public class LinearFog
extends Fog {
    public static final int ALLOW_DISTANCE_READ = 16;
    public static final int ALLOW_DISTANCE_WRITE = 17;
    private static final int[] readCapabilities = new int[]{16};

    public LinearFog() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public LinearFog(Color3f color3f) {
        super(color3f);
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public LinearFog(Color3f color3f, double d2, double d3) {
        super(color3f);
        this.setDefaultReadCapabilities(readCapabilities);
        ((LinearFogRetained)this.retained).initFrontDistance(d2);
        ((LinearFogRetained)this.retained).initBackDistance(d3);
    }

    public LinearFog(float f2, float f3, float f4) {
        super(f2, f3, f4);
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public LinearFog(float f2, float f3, float f4, double d2, double d3) {
        super(f2, f3, f4);
        this.setDefaultReadCapabilities(readCapabilities);
        ((LinearFogRetained)this.retained).initFrontDistance(d2);
        ((LinearFogRetained)this.retained).initBackDistance(d3);
    }

    public void setFrontDistance(double d2) {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("LinearFog0"));
        }
        if (this.isLive()) {
            ((LinearFogRetained)this.retained).setFrontDistance(d2);
        } else {
            ((LinearFogRetained)this.retained).initFrontDistance(d2);
        }
    }

    public double getFrontDistance() {
        if (this.isLiveOrCompiled() && !this.getCapability(16)) {
            throw new CapabilityNotSetException(J3dI18N.getString("LinearFog1"));
        }
        return ((LinearFogRetained)this.retained).getFrontDistance();
    }

    public void setBackDistance(double d2) {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("LinearFog0"));
        }
        if (this.isLive()) {
            ((LinearFogRetained)this.retained).setBackDistance(d2);
        } else {
            ((LinearFogRetained)this.retained).initBackDistance(d2);
        }
    }

    public double getBackDistance() {
        if (this.isLiveOrCompiled() && !this.getCapability(16)) {
            throw new CapabilityNotSetException(J3dI18N.getString("LinearFog1"));
        }
        return ((LinearFogRetained)this.retained).getBackDistance();
    }

    void createRetained() {
        this.retained = new LinearFogRetained();
        this.retained.setSource(this);
    }

    public Node cloneNode(boolean bl) {
        LinearFog linearFog = new LinearFog();
        linearFog.duplicateNode(this, bl);
        return linearFog;
    }

    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        LinearFogRetained linearFogRetained = (LinearFogRetained)node.retained;
        LinearFogRetained linearFogRetained2 = (LinearFogRetained)this.retained;
        linearFogRetained2.initFrontDistance(linearFogRetained.getFrontDistance());
        linearFogRetained2.initBackDistance(linearFogRetained.getBackDistance());
    }
}

